<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Blog extends Model 
{

    protected $table = 'blogs';
    public $timestamps = true;
    protected $fillable = array('name', 'description', 'blog_category_id');

    public function files()
    {
        return $this->morphMany('App\Models\File', 'fileable');
    }

    public function category()
    {
        return $this->belongsTo('App\Models\BlogCategory', 'blog_category_id');
    }

}